"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RecordsDiff_exports = {};
__export(RecordsDiff_exports, {
  createEmptyRecordsDiff: () => createEmptyRecordsDiff,
  isRecordsDiffEmpty: () => isRecordsDiffEmpty,
  reverseRecordsDiff: () => reverseRecordsDiff,
  squashRecordDiffs: () => squashRecordDiffs,
  squashRecordDiffsMutable: () => squashRecordDiffsMutable
});
module.exports = __toCommonJS(RecordsDiff_exports);
var import_utils = require("@tldraw/utils");
function createEmptyRecordsDiff() {
  return { added: {}, updated: {}, removed: {} };
}
function reverseRecordsDiff(diff) {
  const result = { added: diff.removed, removed: diff.added, updated: {} };
  for (const [from, to] of Object.values(diff.updated)) {
    result.updated[from.id] = [to, from];
  }
  return result;
}
function isRecordsDiffEmpty(diff) {
  return Object.keys(diff.added).length === 0 && Object.keys(diff.updated).length === 0 && Object.keys(diff.removed).length === 0;
}
function squashRecordDiffs(diffs) {
  const result = { added: {}, removed: {}, updated: {} };
  squashRecordDiffsMutable(result, diffs);
  return result;
}
function squashRecordDiffsMutable(target, diffs) {
  for (const diff of diffs) {
    for (const [id, value] of (0, import_utils.objectMapEntries)(diff.added)) {
      if (target.removed[id]) {
        const original = target.removed[id];
        delete target.removed[id];
        if (original !== value) {
          target.updated[id] = [original, value];
        }
      } else {
        target.added[id] = value;
      }
    }
    for (const [id, [_from, to]] of (0, import_utils.objectMapEntries)(diff.updated)) {
      if (target.added[id]) {
        target.added[id] = to;
        delete target.updated[id];
        delete target.removed[id];
        continue;
      }
      if (target.updated[id]) {
        target.updated[id] = [target.updated[id][0], to];
        delete target.removed[id];
        continue;
      }
      target.updated[id] = diff.updated[id];
      delete target.removed[id];
    }
    for (const [id, value] of (0, import_utils.objectMapEntries)(diff.removed)) {
      if (target.added[id]) {
        delete target.added[id];
      } else if (target.updated[id]) {
        target.removed[id] = target.updated[id][0];
        delete target.updated[id];
      } else {
        target.removed[id] = value;
      }
    }
  }
}
//# sourceMappingURL=RecordsDiff.js.map
